﻿<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Towary" %>
<%@ Import Namespace="System.Collections" %>
<%@ Import Namespace="System.Diagnostics" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Cennik</title>
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
		<script runat="server">

Hashtable ht = new Hashtable();
readonly static object błędna = new object();
ArrayList arr = new ArrayList();

static string nazwa(Towar towar) {
	return Soneta.Fiskal.FiskalPrinter.NazwaFiskalna(towar).ToUpper();
}

class NazwaComparer : IComparer {
    public int Compare(object obj1, object obj2) {
        Towar t1 = (Towar)obj1;
        Towar t2 = (Towar)obj2;
        return string.Compare(nazwa(t1), nazwa(t2));
    }
}

void OnContextLoad(Object sender, EventArgs args) {
	TowaryModule tm = TowaryModule.GetInstance(dc);
	
	int licznik = 0;
	foreach (Towar towar in tm.Towary) {
		if (++licznik % 100 == 0)
			System.Diagnostics.Trace.Write("Analizuje towary: "+licznik, "Progress");
			
		string n = nazwa(towar);
		object v = ht[n];
		if (v==null) 
			ht[n] = towar.DefinicjaStawki;
		else if (v!=błędna && v!=towar.DefinicjaStawki) 
			ht[n] = błędna;
	}
	
	foreach (Towar towar in tm.Towary)
		if (ht[nazwa(towar)]==błędna)
			arr.Add(towar);
	
	arr.Sort(new NazwaComparer());
	
	Grid.DataSource = arr;
}

void Grid_BeforeRow(object sender, RowEventArgs args) {
	Towar towar = (Towar)args.Row;
	Grid.GroupLine = "Nazwa fiskalna: "+nazwa(towar);
}

		</script>
	</HEAD>
	<body>
		<form method="post" runat="server" ID="Form1">
			<ea:DataContext id="dc" runat="server" oncontextload="OnContextLoad"></ea:DataContext>
			<eb:ReportHeader id="ReportHeader" title="Towary z błędem PTU|</strong>Towary, które są nierozróżnialne dla drukarki fiskalnej,|a mają różną stawkę VAT.|Podczas drukowania paragonu powstaje błąd PTU."
				runat="server"></eb:ReportHeader>
			<ea:Grid id="Grid" runat="server" RowTypeName="Soneta.Towary.Towar,Soneta.Handel" OnBeforeRow="Grid_BeforeRow">
				<Columns>
					<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="LP." EncodeHTML="True" runat="server"></ea:GridColumn>
					<ea:GridColumn Width="16" Align="Left" DataMember="Kod" Caption="Kod" EncodeHTML="True" runat="server"></ea:GridColumn>
					<ea:GridColumn Align="Left" DataMember="Nazwa" Caption="Nazwa" EncodeHTML="True" runat="server"></ea:GridColumn>
					<ea:GridColumn Width="15" Align="Left" DataMember="EAN" Caption="EAN" EncodeHTML="True" runat="server"></ea:GridColumn>
					<ea:GridColumn Width="15" Align="Center" DataMember="DefinicjaStawki" Caption="Stawka VAT" EncodeHTML="True" runat="server"></ea:GridColumn>
				</Columns>
			</ea:Grid>
			<eb:ReportFooter id="ReportFooter" runat="server" TheEnd="False"></eb:ReportFooter>
		</form>
	</body>
</HTML>

